package gov.va.med.mhv.calendar.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "USER_CALENDAR_VIEW")
public class UserCalView implements Serializable {	
	
	private static final long serialVersionUID = -2300904008692885853L;

	@Id
	@Column(name = "VIEW_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long userCalViewId;

	@Column(name = "OPLOCK")
	private Integer oplock;

	// TODO: Build Enumerated type
	@Column(name = "PREFERRED_VIEW")
	private String preferredView;

	@Column(name = "VHA_REMINDERS", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean vhaReminders;

	@Column(name = "PERSONAL_EVENT_FILTER", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean personalEventFilter;

	@Column(name = "ZIP_CODE")
	private String zipCode;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VISN_VISN_ID")
	private Visn visn;
	
	public Long getUserCalViewId() {
		return userCalViewId;
	}

	public void setUserCalViewId(Long userCalViewId) {
		this.userCalViewId = userCalViewId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public Boolean getVhaReminders() {
		return vhaReminders;
	}

	public void setVhaReminders(Boolean vhaReminders) {
		this.vhaReminders = vhaReminders;
	}

	public Boolean getPersonalEventFilter() {
		return personalEventFilter;
	}

	public void setPersonalEventFilter(Boolean personalEventFilter) {
		this.personalEventFilter = personalEventFilter;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public Visn getVisn() {
		return visn;
	}

	public void setVisn(Visn visn) {
		this.visn = visn;
	}

	public String getPreferredView() {
		return preferredView;
	}

	public void setPreferredView(String preferredView) {
		this.preferredView = preferredView;
	}

}
